/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.api2.utils.QuestLineSorter;
import betterquesting.questing.QuestLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;

public final class QuestLineDatabase
extends SimpleDatabase<IQuestLine>
implements IQuestLineDatabase {
    public static final QuestLineDatabase INSTANCE = new QuestLineDatabase();
    private final List<Integer> lineOrder = new ArrayList<Integer>();
    private final QuestLineSorter SORTER = new QuestLineSorter(this);

    @Override
    public synchronized int getOrderIndex(int lineID) {
        int order = this.lineOrder.indexOf(lineID);
        if (order >= 0) {
            return order;
        }
        if (this.getValue(lineID) == null) {
            return -1;
        }
        this.lineOrder.add(lineID);
        return this.lineOrder.size() - 1;
    }

    @Override
    public synchronized void setOrderIndex(int lineID, int index) {
        this.lineOrder.remove((Object)lineID);
        this.lineOrder.add(MathHelper.func_76125_a((int)index, (int)0, (int)this.lineOrder.size()), lineID);
    }

    @Override
    public synchronized List<DBEntry<IQuestLine>> getSortedEntries() {
        ArrayList<DBEntry<IQuestLine>> list = new ArrayList<DBEntry<IQuestLine>>(this.getEntries());
        list.sort(this.SORTER);
        return list;
    }

    @Override
    public synchronized IQuestLine createNew(int id) {
        QuestLine ql = new QuestLine();
        if (id >= 0) {
            this.add(id, ql);
        }
        return ql;
    }

    @Override
    public synchronized void removeQuest(int questID) {
        for (DBEntry ql : this.getEntries()) {
            ((IQuestLine)ql.getValue()).removeID(questID);
        }
    }

    @Override
    public synchronized NBTTagList writeToNBT(NBTTagList json, @Nullable List<Integer> subset) {
        for (DBEntry entry : this.getEntries()) {
            if (subset != null && !subset.contains(entry.getID())) continue;
            NBTTagCompound jObj = ((IQuestLine)entry.getValue()).writeToNBT(new NBTTagCompound(), null);
            jObj.func_74768_a("lineID", entry.getID());
            jObj.func_74768_a("order", this.getOrderIndex(entry.getID()));
            json.func_74742_a((NBTBase)jObj);
        }
        return json;
    }

    @Override
    public synchronized void readFromNBT(NBTTagList json, boolean merge) {
        if (!merge) {
            this.reset();
        }
        ArrayList<IQuestLine> unassigned = new ArrayList<IQuestLine>();
        HashMap<Integer, Integer> orderMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound jql = json.func_150305_b(i);
            int id = jql.func_150297_b("lineID", 99) ? jql.func_74762_e("lineID") : -1;
            int order = jql.func_150297_b("order", 99) ? jql.func_74762_e("order") : -1;
            IQuestLine line = (IQuestLine)this.getValue(id);
            if (line == null) {
                line = new QuestLine();
            }
            line.readFromNBT(jql, false);
            if (id >= 0) {
                this.add(id, line);
            } else {
                unassigned.add(line);
            }
            if (order < 0) continue;
            orderMap.put(order, id);
        }
        for (IQuestLine q : unassigned) {
            this.add(this.nextID(), q);
        }
        ArrayList orderKeys = new ArrayList(orderMap.keySet());
        Collections.sort(orderKeys);
        this.lineOrder.clear();
        Iterator iterator = orderKeys.iterator();
        while (iterator.hasNext()) {
            int o = (Integer)iterator.next();
            this.lineOrder.add((Integer)orderMap.get(o));
        }
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.lineOrder.clear();
    }
}

